package com.example.sefinsa_app.utilities;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.navigation.Navigation;
import androidx.recyclerview.widget.RecyclerView;

import com.example.sefinsa_app.R;
import com.example.sefinsa_app.models.Cliente;
import com.example.sefinsa_app.models.RegistroCredito;

import java.util.ArrayList;

public class RegistroCreditoAdapter extends RecyclerView.Adapter<RegistroCreditoAdapter.RegistroCreditoViewHolder>{

    Context context;
    ArrayList<RegistroCredito> registroCredito;
    private SharedPreferences sesion;

    public RegistroCreditoAdapter(Context context, ArrayList<RegistroCredito> registroCredito) {
        this.context = context;
        this.registroCredito = registroCredito;
    }

    public void setListaFiltrada(ArrayList<RegistroCredito> filteredListRegistroCredito){
        this.registroCredito = filteredListRegistroCredito;
        notifyDataSetChanged();
    }


    @NonNull
    @Override
    public RegistroCreditoAdapter.RegistroCreditoViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View v = LayoutInflater.from(context).inflate(R.layout.pago_item, parent, false);
        return new RegistroCreditoAdapter.RegistroCreditoViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull RegistroCreditoAdapter.RegistroCreditoViewHolder holder, int position) {
        holder.imprimir(position);

    }

    @Override
    public int getItemCount() {
        return registroCredito.size();
    }

    public void clear() {
        registroCredito.clear();
        notifyDataSetChanged();
    }

    public void addAll(ArrayList<RegistroCredito> list) {
        registroCredito = list;
        notifyDataSetChanged();
    }

    public class RegistroCreditoViewHolder extends RecyclerView.ViewHolder{

        TextView tvTarjetonPago, tvClientePago, tvDireccionPago, tvTelefonoPago, tvAvalPago, tvDireccionAvalPago,
        tvTelefonoAvalPago, tvMontoPago, tvSemanalPago, tvSem1Pago, tvSem2Pago, tvSem3Pago, tvSem4Pago, tvSem5Pago
                , tvSem6Pago, tvSem7Pago, tvSem8Pago, tvSem9Pago, tvSem10Pago, tvSem11Pago, tvSem12Pago, tvSem13Pago
                , tvSem14Pago, tvSem15Pago, tvSem16Pago, tvSem17Pago, tvSem18Pago, tvSem19Pago, tvSem20Pago;

        public RegistroCreditoViewHolder(@NonNull View itemView) {
            super(itemView);

            /*tvTarjetonPago = itemView.findViewById(R.id.tarjetonPago);
            tvClientePago = itemView.findViewById(R.id.clientePago);*/
            tvDireccionPago = itemView.findViewById(R.id.direccionPago);
            tvTelefonoPago = itemView.findViewById(R.id.telefonoPago);
            tvAvalPago = itemView.findViewById(R.id.avalPago);
            tvDireccionAvalPago = itemView.findViewById(R.id.direccionAvalPago);
            tvTelefonoAvalPago = itemView.findViewById(R.id.telefonoAvalPago);
            tvMontoPago = itemView.findViewById(R.id.montoPago);
            tvSemanalPago = itemView.findViewById(R.id.semanalPago);
            tvSem1Pago = itemView.findViewById(R.id.sem1Pago);
            tvSem2Pago = itemView.findViewById(R.id.sem2Pago);
            tvSem3Pago = itemView.findViewById(R.id.sem3Pago);
            tvSem4Pago = itemView.findViewById(R.id.sem4Pago);
            tvSem5Pago = itemView.findViewById(R.id.sem5Pago);
            tvSem6Pago = itemView.findViewById(R.id.sem6Pago);
            tvSem7Pago = itemView.findViewById(R.id.sem7Pago);
            tvSem8Pago = itemView.findViewById(R.id.sem8Pago);
            tvSem9Pago = itemView.findViewById(R.id.sem9Pago);
            tvSem10Pago = itemView.findViewById(R.id.sem10Pago);
            tvSem11Pago = itemView.findViewById(R.id.sem11Pago);
            tvSem12Pago = itemView.findViewById(R.id.sem12Pago);
            tvSem13Pago = itemView.findViewById(R.id.sem13Pago);
            tvSem14Pago = itemView.findViewById(R.id.sem14Pago);
            tvSem15Pago = itemView.findViewById(R.id.sem15Pago);
            tvSem16Pago = itemView.findViewById(R.id.sem16Pago);
            tvSem17Pago = itemView.findViewById(R.id.sem17Pago);
            tvSem18Pago = itemView.findViewById(R.id.sem18Pago);
            tvSem19Pago = itemView.findViewById(R.id.sem19Pago);
            tvSem20Pago = itemView.findViewById(R.id.sem20Pago);

        }

        public void imprimir(int position) {

            /*tvTarjetonPago.setText(registroCredito.get(position).getNumero_tarjeton());
            tvClientePago.setText(registroCredito.get(position).getNombre_completo());*/
            tvDireccionPago.setText(registroCredito.get(position).getDireccion());
            tvTelefonoPago.setText(registroCredito.get(position).getTelefono());
            tvAvalPago.setText(registroCredito.get(position).getNombre_aval());

            tvDireccionAvalPago.setText(registroCredito.get(position).getDireccion_aval());
            tvTelefonoAvalPago.setText(registroCredito.get(position).getTelefono_aval());
            tvMontoPago.setText(registroCredito.get(position).getMonto_prestado());
            tvSemanalPago.setText(registroCredito.get(position).getPago_semanal());
            tvSem1Pago.setText(registroCredito.get(position).getSemana1().split(" ")[0]);
            tvSem2Pago.setText(registroCredito.get(position).getSemana2().split(" ")[0]);
            tvSem3Pago.setText(registroCredito.get(position).getSemana3().split(" ")[0]);
            tvSem4Pago.setText(registroCredito.get(position).getSemana4().split(" ")[0]);
            tvSem5Pago.setText(registroCredito.get(position).getSemana5().split(" ")[0]);
            tvSem6Pago.setText(registroCredito.get(position).getSemana6().split(" ")[0]);
            tvSem7Pago.setText(registroCredito.get(position).getSemana7().split(" ")[0]);
            tvSem8Pago.setText(registroCredito.get(position).getSemana8().split(" ")[0]);
            tvSem9Pago.setText(registroCredito.get(position).getSemana9().split(" ")[0]);
            tvSem10Pago.setText(registroCredito.get(position).getSemana10().split(" ")[0]);
            tvSem11Pago.setText(registroCredito.get(position).getSemana11().split(" ")[0]);
            tvSem12Pago.setText(registroCredito.get(position).getSemana12().split(" ")[0]);
            tvSem13Pago.setText(registroCredito.get(position).getSemana13().split(" ")[0]);
            tvSem14Pago.setText(registroCredito.get(position).getSemana14().split(" ")[0]);
            tvSem15Pago.setText(registroCredito.get(position).getSemana15().split(" ")[0]);
            tvSem16Pago.setText((registroCredito.get(position).getSemana16() == null) ? "" : registroCredito.get(position).getSemana16().split(" ")[0]);
            tvSem17Pago.setText((registroCredito.get(position).getSemana17() == null) ? "" : registroCredito.get(position).getSemana17().split(" ")[0]);
            tvSem18Pago.setText((registroCredito.get(position).getSemana18() == null) ? "" : registroCredito.get(position).getSemana18().split(" ")[0]);
            tvSem19Pago.setText((registroCredito.get(position).getSemana19() == null) ? "" : registroCredito.get(position).getSemana19().split(" ")[0]);
            tvSem20Pago.setText((registroCredito.get(position).getSemana20() == null) ? "" : registroCredito.get(position).getSemana20().split(" ")[0]);


            if(registroCredito.get(position).getSemana1().contains("badge-success")){
                tvSem1Pago.setBackgroundResource(R.color.success);
                tvSem1Pago.setTextColor(context.getResources().getColor(R.color.white));
            }
            else if(registroCredito.get(position).getSemana1().contains("badge-warning")){
                tvSem1Pago.setBackgroundResource(R.color.warning);
            }
            else if(registroCredito.get(position).getSemana1().contains("badge-light")){
                tvSem1Pago.setBackgroundResource(R.color.danger);
                tvSem1Pago.setTextColor(context.getResources().getColor(R.color.white));
            }
            else if(registroCredito.get(position).getSemana1().contains("badge-info")){
                tvSem1Pago.setBackgroundResource(R.color.info);
            }
            else{
                tvSem1Pago.setBackgroundResource(R.color.white);
                tvSem1Pago.setTextColor(context.getResources().getColor(R.color.black));
            }

            /*tvNombreCliente.setText("Cliente " + clientes.get(position).getNombre_completo());
            tvDireccionCliente.setText(clientes.get(position).getDireccion());
            tvTelefonoCliente.setText(clientes.get(position).getTelefono());
            tvRutaCliente.setText(clientes.get(position).getNombre_ruta());
            tvPoblacionCliente.setText(clientes.get(position).getNombre_poblacion());
            tvColocadoraCliente.setText(clientes.get(position).getNombre_colocadora());
            tvGarantiasCliente.setText(clientes.get(position).getGarantias());

            if(sesion.getString("nombre_perfil", "").equals("COBRADOR")){
                btnEditarCliente.setText("GENERAR PRESTAMO");

                btnEditarCliente.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        Bundle args = new Bundle();
                        String personJsonString = Utils.getGsonParser().toJson(clientes.get(position));
                        args.putString("cliente", personJsonString);

                        Navigation.findNavController((Activity) context, R.id.nav_host_fragment_content_dashboard)
                                .navigate(R.id.nav_prestamos_crear, args);
                    }
                });
            }
            else{

                btnEditarCliente.setText("EDITAR");

                btnEditarCliente.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        Bundle args = new Bundle();
                        String personJsonString = Utils.getGsonParser().toJson(clientes.get(position));
                        args.putString("cliente", personJsonString);

                        Navigation.findNavController((Activity) context, R.id.nav_host_fragment_content_dashboard)
                                .navigate(R.id.nav_clientes_editar, args);
                    }
                });

            }*/




        }
    }
}
